/* 
 * Copyright 2011 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.fritzapp.gui;

import android.content.Context;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceManager;
import android.preference.PreferenceScreen;
import android.preference.Preference.OnPreferenceChangeListener;
import android.widget.ListView;
import de.avm.android.fritzapp.R;
import de.avm.android.fritzapp.sipua.ui.Sipdroid;
import de.avm.android.fritzapp.util.ResourceHelper;

/* GUI for the settings of hidden test features */
public class SettingsTestActivity extends PreferenceActivity
{
	public static final String DIALCODE = "**##**1";
	private static final String PREF_NOHTTPS = "test_nohttps";
	private static final boolean DEFAULT_NOHTTPS = false;
	private static final String PREF_AUTONOW = Sipdroid.PREF_AUTOON;
	private static final boolean DEFAULT_AUTONOW = false;
	private static final String PREF_AUTODELAYED = Sipdroid.PREF_AUTOONDEMAND;
	private static final boolean DEFAULT_AUTODELAYED = false;

	public static boolean isNoHttps(Context context)
	{
		return PreferenceManager.getDefaultSharedPreferences(context)
				.getBoolean(PREF_NOHTTPS, DEFAULT_NOHTTPS);
	}
	
	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);

		setContentView(R.layout.settings);
		ListView preferenceView = (ListView)findViewById(android.R.id.list);
		preferenceView.setSelector(R.drawable.list_selector_background);

		PreferenceScreen screen = createPreferenceScreen(savedInstanceState);
		screen.setPersistent(true);
		screen.bind(preferenceView);
		preferenceView.setAdapter(screen.getRootAdapter());
		setPreferenceScreen(screen);

		// Title
		ResourceHelper.setAltTitleSymbol(this);
		ResourceHelper.setTitle(this, R.string.settings_test);
	}

	private PreferenceScreen createPreferenceScreen(Bundle savedInstanceState)
	{
		PreferenceScreen root = getPreferenceManager()
				.createPreferenceScreen(this);

		// no HTTPS
		CheckBoxPreference checkPref = new CheckBoxPreference(this);
		checkPref.setKey(PREF_NOHTTPS);
		checkPref.setDefaultValue(DEFAULT_NOHTTPS);
		checkPref.setTitle(R.string.settings_test_nohttps);
		checkPref.setSummary(R.string.settings_test_nohttps2);
		root.addPreference(checkPref);

		// auto on
		final CheckBoxPreference autoNowPref = new CheckBoxPreference(this);
		autoNowPref.setKey(PREF_AUTONOW);
		autoNowPref.setDefaultValue(DEFAULT_AUTONOW);
		autoNowPref.setTitle(R.string.settings_test_autonow);
		autoNowPref.setSummary(R.string.settings_test_autonow2);
		root.addPreference(autoNowPref);

		// auto on delayed
		final CheckBoxPreference autoDeleayedPref = new CheckBoxPreference(this);
		autoDeleayedPref.setKey(PREF_AUTODELAYED);
		autoDeleayedPref.setDefaultValue(DEFAULT_AUTODELAYED);
		autoDeleayedPref.setTitle(R.string.settings_test_autodelayed);
		autoDeleayedPref.setSummary(R.string.settings_test_autodelayed2);
		root.addPreference(autoDeleayedPref);
		
		autoNowPref.setOnPreferenceChangeListener(new OnPreferenceChangeListener()
		{
			public boolean onPreferenceChange(Preference preference,
					Object newValue)
			{
				if ((Boolean)newValue && autoDeleayedPref.isChecked())
					autoDeleayedPref.setChecked(false);
				return true;
			}
		});
		autoDeleayedPref.setOnPreferenceChangeListener(new OnPreferenceChangeListener()
		{
			public boolean onPreferenceChange(Preference preference,
					Object newValue)
			{
				if ((Boolean)newValue && autoNowPref.isChecked())
					autoNowPref.setChecked(false);
				return true;
			}
		});
		
		return root;
	}

	/**
	 * Preparations on settings to do on app's start
	 * @param context context for reading and writing the settings
	 * @param firstRun true for first run after install
	 */
	public static void prepareSettings(Context context, boolean firstRun)
	{
		// nothing to do
	}
}
