/*
 * Copyright (C) 2005 Luca Veltri - University of Parma - Italy
 * 
 * This file is part of MjSip (http://www.mjsip.org)
 * 
 * MjSip is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * MjSip is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with MjSip; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * Author(s):
 * Luca Veltri (luca.veltri@unipr.it)
 */

package org.zoolu.sip.transaction;

import org.zoolu.sip.message.Message;

/**
 * A TransactionClientListener listens for TransactionClient events. It collects
 * all TransactionClient callback functions.
 */
public interface TransactionClientListener {
	/**
	 * When the TransactionClient is (or goes) in "Proceeding" state and
	 * receives a new 1xx provisional response
	 */
	public void onTransProvisionalResponse(TransactionClient tc, Message resp);

	/**
	 * When the TransactionClient goes into the "Completed" state receiving a
	 * 2xx response
	 */
	public void onTransSuccessResponse(TransactionClient tc, Message resp);

	/**
	 * When the TransactionClient goes into the "Completed" state receiving a
	 * 300-699 response
	 */
	public void onTransFailureResponse(TransactionClient tc, Message resp);

	/**
	 * When the TransactionClient goes into the "Terminated" state, caused by
	 * transaction timeout
	 */
	public void onTransTimeout(TransactionClient tc);
}
