/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.model.PortMapping;

public class AddPortMapping extends WANPPPConnectionSoapHelper<Boolean> {
	private PortMapping mPortMapping = new PortMapping();

	public AddPortMapping(ISoapCredentials soapCredentials,
			PortMapping portMapping) {
		super(soapCredentials);

		mPortMapping = portMapping;
	}

	@Override
	public Boolean getQualifiedResult() throws DataMisformatException,
			BaseException, IOException {
		String input = getSoapBody();
		
		// no out parameter, check for error response
		Matcher m = Pattern.compile("faultcode>(.*?)<\\/faultcode")
				.matcher(input);
		if (m.find())
			throw new DataMisformatException(MISFORMATEXCEPTIONDESCRIPTION);

		return Boolean.TRUE;
	}

	@Override
	public String getSoapMethodParameter() {
		String params = "<NewRemoteHost>" + mPortMapping.getRemoteHost() + "</NewRemoteHost>" +
				"<NewExternalPort>" + mPortMapping.getExternalPort() + "</NewExternalPort>" +
				"<NewProtocol>" + mPortMapping.getProtocol() + "</NewProtocol>" +
				"<NewInternalPort>" + mPortMapping.getInternalPort() + "</NewInternalPort>" +
				"<NewInternalClient>" + mPortMapping.getInternalClient() + "</NewInternalClient>" +
				"<NewEnabled>" + (mPortMapping.isEnabled() ? 1 : 0) + "</NewEnabled>" +
				"<NewPortMappingDescription>" + mPortMapping.getPortMappingDescription() + "</NewPortMappingDescription>" +
				"<NewLeaseDuration>" + mPortMapping.getLeaseDuration() + "</NewLeaseDuration>";
		return params;
	}

	@Override
	public String getSoapMethod() {
		return "AddPortMapping";
	}
}