/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;

public class CreateUrlsSid extends DeviceConfigSoapHelper<String>
{
	public CreateUrlsSid(ISoapCredentials soapCredentials)
	{
		super(soapCredentials);
	}

	@Override
	public String getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		String input = getSoapBody();
		Matcher m = Pattern.compile("NewX_AVM-DE_UrlSID>(.*?)<\\/NewX_AVM-DE_UrlSID")
				.matcher(input);
		if (m.find())
			return decodeEntities(m.group(1));
		else
			throw new DataMisformatException("Invalid Response from DeviceInfo Service");
	}

	@Override
	public String getSoapMethod() {
		return "X_AVM-DE_CreateUrlSID";
	}
}