/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.model.VoIPInfoEx;

/* Soap implementation for the VoIPConf-Interface */
public class GetVoIPConfInfoEx extends VoIPConfSoapHelper<VoIPInfoEx>
{
	public GetVoIPConfInfoEx(ISoapCredentials soapCredentials)
	{
		super(soapCredentials);
	}

	@Override
	public VoIPInfoEx getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		String input = getSoapBody();
		VoIPInfoEx infoEx = new VoIPInfoEx(); 

		try
		{
			Matcher m = Pattern.compile("NewVoIPPasswordMinChars>(.*?)<\\/NewVoIPPasswordMinChars").matcher(input);
			int intVal = (m.find()) ? Integer.parseInt(m.group(1)) : -1;
			if (intVal < 0)
				throw new DataMisformatException("Invalid Response from VoIPConf Service");
			else
				infoEx.setPasswordMinChar(intVal);
			m = Pattern.compile("NewVoIPPasswordMaxChars>(.*?)<\\/NewVoIPPasswordMaxChars").matcher(input);
			intVal = (m.find()) ? Integer.parseInt(m.group(1)) : -1;
			if (intVal < 0)
				throw new DataMisformatException("Invalid Response from VoIPConf Service");
			else
				infoEx.setPasswordMaxChar(intVal);
			m = Pattern.compile("NewVoIPPasswordAllowedChars>(.*?)<\\/NewVoIPPasswordAllowedChars")
					.matcher(input);
			if (m.find())
			{
				String allowed = decodeEntities(m.group(1));
				if (allowed.length() > 0)
					infoEx.setPasswordAllowedChar(allowed);
				else
					throw new DataMisformatException("Invalid Response from VoIPConf Service");
			}
			else
				throw new DataMisformatException("Invalid Response from VoIPConf Service");
		}
		catch(NumberFormatException  exp)
		{
			throw new DataMisformatException("Invalid Response from VoIPConf Service", exp);
		}

		return infoEx;
	}

	@Override
	public String getSoapMethod()
	{
		return "GetInfoEx";
	}
}