/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap;

import java.security.KeyStore;

public interface ISoapCredentials
{
	/**
	 * Gets Host of TR-064 device
	 * @return host
	 */
	String getHost();
	
	/**
	 * Gets Port to use for TR-064 actions
	 * @param ssl true to get SSL port, otherwise none-SSL port
	 * @return port
	 */
	int getPort(boolean ssl);
	
	/**
	 * Gets if SSL should not be used (e.g. by user setting)
	 * @return true to invoke actions without SSL
	 */
	boolean isSuppressSSL();

	/**
	 * Gets name of soap user
	 * @return username
	 */
	String getUsername();
	
	/**
	 * Gets password of soap user
	 * @return password
	 */
	String getPassword();
	
	/**
	 * Gets trusted certificates of Server if known
	 * @return KeyStore or null
	 */
	KeyStore getTrustedServerCertificates();
	
	/**
	 * With older FWs, host of download URLs might have to be fixed
	 * (needed with phonebook and call list)
	 * @return true to apply fix
	 */
	boolean shouldFixDownloadUrl();
}
