/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap;

public abstract class WLANSoapHelper<RESULT> extends AbstractSoapHelper<RESULT>
{
	/*
	Service Id  urn:WLANConfiguration-com:serviceId:WLANConfiguration<interfaceIndex> 
	Service Type  urn:dslforum-org:service:WLANConfiguration:<interfaceIndex> 
	Control Url  /upnp/control/wlanconfig<interfaceIndex> 
	Scpd Url  /wlanconfigSCPD.xml 
	*/
	
	private int mInterfaceIndex;
	
	public WLANSoapHelper(ISoapCredentials soapCredentials, int interfaceIndex)
	{
		super(soapCredentials);
		mInterfaceIndex = interfaceIndex;
	}

	public String getNamespace()
	{
		return "urn:dslforum-org:service:WLANConfiguration:" + mInterfaceIndex;
	}

	public String getControlURL()
	{
		return "/upnp/control/wlanconfig" + mInterfaceIndex;
	}

}