/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;

/* Soap implementation for the phonebook-Interface */
public class GetPhonebookName extends OnTelSoapHelper<String>
{
	private String mPhoneBookId;

	/**
	 * Instantiates a new gets the phonebook name.
	 * 
	 * @param phoneBookid
	 *            the phone bookid
	 * @param c
	 *            the c
	 */
	public GetPhonebookName(ISoapCredentials soapCredentials, String phoneBookid)
	{
		super(soapCredentials);
		mPhoneBookId = phoneBookid;
	}

	@Override
	public String getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		String input = getSoapBody();

		// Name
		Matcher m = Pattern.compile("NewPhonebookName>(.*?)<").matcher(input);
		if (m.find())
			return decodeEntities(m.group(1));
		else
			throw new DataMisformatException("Invalid Response from PhoneBook Service");
	}

	@Override
	public String getSoapMethodParameter()
	{
		return "<NewPhonebookId>" + mPhoneBookId + "</NewPhonebookId>";
	}

	@Override
	public String getSoapMethod()
	{
		return "GetPhonebook";
	}
}