/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.fritzapp.gui;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import de.avm.android.fritzapp.R;
import de.avm.android.fritzapp.util.ResourceHelper;

public class Help
{
	public enum HelpTopic { GENERAL, FINDBOX };

	/**
	 * Show general help in dialog as child of the activity
	 * 
	 * @param context
	 * 			the context of an activity
	 */
	public static void showHelp(final Context context)
	{
		showHelp(context, HelpTopic.GENERAL);
	}

	/**
	 * Show help topic in dialog as child of the activity
	 * 
	 * @param context
	 * 			the context
	 * @param topic
	 * 			help topic to be shown
	 */
	public static void showHelp(final Context context, HelpTopic topic)
	{
		String title;
		if (topic == HelpTopic.GENERAL)
			title = context.getString(R.string.menu_help);
		else
			title = TextDialog.getDefaultTitle(context);

		if (Activity.class.isAssignableFrom(context.getClass()))
		{
			// dialog as child of activity
			TextDialog.create(context, title,
					ResourceHelper.getTextForHelpTopic(topic, context),
                    TextDialog.DEFAULT_MESSAGE_ICON)
					.setNegativeButton(R.string.settings_label,
							new DialogInterface.OnClickListener()
					{
						public void onClick(DialogInterface dialog, int which)
						{
							Intent i = new Intent(context, SettingsActivity.class);
							context.startActivity(i);
						}
					}).show();
		}
		else
		{
			// dialog with no activity
			DialogActivity.startMessageDialog(context, title,
					ResourceHelper.getTextForHelpTopic(topic, context),
					android.R.drawable.ic_dialog_alert, true);
		}
	}


	/**
	 * Show about-info dialog
	 * 
	 * @param context
	 * 			the context of an activity
	 */
	public static void showAbout(Context context)
	{
		if (!Activity.class.isAssignableFrom(context.getClass()))
			throw new IllegalArgumentException("Argument context must be an activity");
		
		TextDialog.create(context,
				context.getString(R.string.menu_about),
				context.getString(R.string.about_text)
                        .replace("\\n","\n")
				        .replace("${NAME}", context.getString(R.string.app_name))
				        .replace("${VERSION}", ResourceHelper.getVersion(context)),
                TextDialog.DEFAULT_MESSAGE_ICON).show();
	}
}
