/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.fritzapp.service;

import java.security.cert.X509Certificate;
import de.avm.android.fritzapp.com.ConnectionProblem;
import de.avm.android.fritzapp.gui.TextDialog;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;

public class ComErrorMessage implements Parcelable
{
	private long mTimeStamp = 0;
	private ConnectionProblem mProblem = null;
	private String mMessage;
	private String mAdditionalMessage = null;
	private String mUdn = null;
	private X509Certificate mCertificate = null;
	private boolean mHasAnonymousLogin = false;
	private int mIcon = TextDialog.ICON_NONE;
	
	public long getTimeStamp()
	{
		return mTimeStamp;
	}
	
	public ConnectionProblem getProblem()
	{
		return mProblem;
	}

	public String getMessage()
	{
		return mMessage;
	}

	public String getAdditionalMessage()
	{
		return mAdditionalMessage;
	}

	public int getIconResId()
	{
		return mIcon;
	}
	
	public String getUdn()
	{
		return mUdn;
	}
	
	public X509Certificate getCertificate()
	{
		return mCertificate;
	}
	
	public boolean getHasAnonymousLogin()
	{
		return mHasAnonymousLogin;
	}
	
	public ComErrorMessage(Context context, ConnectionProblem problem)
	{
		mTimeStamp = System.currentTimeMillis();
		mProblem = problem;
		mMessage = problem.getDisplayMessage(context);
		if (problem.isError() &&
				(problem != ConnectionProblem.FRITZBOX_NOTR064) &&
				(problem != ConnectionProblem.SSL_ERROR) &&
				(problem != ConnectionProblem.FRITZBOX_PASSWORD) &&
				(problem != ConnectionProblem.CERTIFICATE_ERROR))
			mIcon = android.R.drawable.ic_dialog_alert;
	}

	public ComErrorMessage(Context context, ConnectionProblem problem,
			String udn, X509Certificate certificate)
	{
		this(context, problem);
		mUdn = udn;
		mCertificate = certificate;
	}

	public ComErrorMessage(Context context, ConnectionProblem problem,
			String udn, String additionalMessage, boolean hasAnonymousLogin)
	{
		this(context, problem);
		mUdn = udn;
		mAdditionalMessage = additionalMessage;
		mHasAnonymousLogin = hasAnonymousLogin;
	}

	public ComErrorMessage(String message)
	{
		mTimeStamp = System.currentTimeMillis();
		mMessage = message;
	}

	public ComErrorMessage(String message, int iconResId)
	{
		mTimeStamp = System.currentTimeMillis();
		mMessage = message;
		mIcon = iconResId;
	}

	public ComErrorMessage(Parcel in)
	{
		mTimeStamp = in.readLong();
		mMessage = in.readString();
		mIcon = in.readInt();
		mUdn = in.readString();
		mCertificate = (X509Certificate)in.readSerializable();
	}
	
	public int describeContents()
	{
		return 0;
	}

	public static final Parcelable.Creator<ComErrorMessage> CREATOR =
			new Parcelable.Creator<ComErrorMessage>()
	{
		public ComErrorMessage createFromParcel(Parcel in)
		{
			return new ComErrorMessage(in);
		}

		public ComErrorMessage[] newArray(int size)
		{
			return new ComErrorMessage[size];
		}
	};

	public void writeToParcel(Parcel out, int flags)
	{
		out.writeLong(mTimeStamp);
		out.writeString(mMessage);
		out.writeInt(mIcon);
		out.writeString(mUdn);
		out.writeSerializable(mCertificate);
	}
}
