/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.fundamentals.adapter;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import de.avm.fundamentals.fragments.IntroFragment;

import java.util.ArrayList;
import java.util.List;

public class IntroPageAdapter extends FragmentPagerAdapter {

    private final Context mContext;
    private final List<TabInfo> mTabs = new ArrayList<TabInfo>();

    public IntroPageAdapter(final Context context, FragmentManager fm) {
        super(fm);
        mContext = context;
    }

    public void addTab(final Bundle args) {
        final Class<?> clss = IntroFragment.class;
        final TabInfo info = new TabInfo(clss, args, clss.getSimpleName());
        mTabs.add(info);
    }

    @Override
    public Fragment getItem(int position) {
        final TabInfo info = mTabs.get(position);
        return Fragment.instantiate(mContext, info.mClass.getName(), info.mArgs);
    }

    @Override
    public int getCount() {
        return mTabs.size();
    }

    static final class TabInfo {
        private final Class<?> mClass;
        private final Bundle mArgs;
        private final String mTitle;

        TabInfo(final Class<?> clss, final Bundle args, final String title) {
            mClass = clss;
            mArgs = args;
            mTitle = title;
        }
    }
}
