/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.fundamentals.logger;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class LogWriter {

    public static final String NEW_LINE = "\n";

    private static LogWriter mInstance = null;

    public static LogWriter getInstance(){
        if(mInstance == null){
            synchronized (LogWriter.class) {
                mInstance = new LogWriter();
            }
        }
        return mInstance;
    }

    public void writeToLog(final String log) throws IOException {
        synchronized (mInstance){
            File file = FileLog.getRecentLogFile();
            FileWriter fileWriter = new FileWriter(file, true);
            fileWriter.append(log);
            fileWriter.append(NEW_LINE);
            fileWriter.close();
        }
    }

}
