/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.fundamentals.utils;

import android.content.Context;

import de.avm.fundamentals.logger.FileLog;

public class AvmUncaughtExceptionHandler implements Thread.UncaughtExceptionHandler {

    private static final String TAG = AvmUncaughtExceptionHandler.class.getSimpleName();
    private final Thread.UncaughtExceptionHandler mOriginalUncaughtExceptionHandler;

    public AvmUncaughtExceptionHandler(Context context) {
        mOriginalUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (!FileLog.isInstantiated()) {
            FileLog.instantiate(context);
        }
    }

    public AvmUncaughtExceptionHandler() {
        mOriginalUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        FileLog.e(TAG, "Uncaught Exception", ex);
        mOriginalUncaughtExceptionHandler.uncaughtException(thread, ex);
    }
}
