/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.fundamentals.views;

import android.app.AlertDialog;
import android.content.Context;
import android.preference.Preference;
import android.text.util.Linkify;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.TextView;
import de.avm.fundamentals.R;
import de.avm.fundamentals.helper.GoogleAnalyticsHelper;

public class PrivacyStatementPreference extends Preference implements Preference.OnPreferenceClickListener {

    private Context mContext;

    public PrivacyStatementPreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        initPreference(context, attrs);
    }

    public PrivacyStatementPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        initPreference(context, attrs);
    }

    private void initPreference(Context context, AttributeSet attrs) {
        mContext = context;
        setTitle(R.string.privacy_statement);
        setOnPreferenceClickListener(this);
    }

    @Override
    public boolean onPreferenceClick(Preference preference) {
        onClickShowPrivacyStatementDialog(mContext);
        return false;
    }

    public static void onClickShowPrivacyStatementDialog(final Context context) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle(R.string.privacy_statement);
        View layout = LayoutInflater.from(context).inflate(R.layout.analytics_dialog, null);
        initLayout(layout);
        builder.setView(layout);
        builder.setPositiveButton(android.R.string.ok, null);
        builder.show();
    }

    private static void initLayout(View layout) {
        CheckBox analyticsCheckBox = (CheckBox) layout.findViewById(R.id.analytics_checkbox);
        analyticsCheckBox.setChecked(!GoogleAnalyticsHelper.getGoogleAnalyticsOptOut());
        analyticsCheckBox.setOnCheckedChangeListener(createOnCheckedChangeListener());
        TextView text = (TextView) layout.findViewById(R.id.analytics_message);
        text.setText(R.string.privacy_statement_message);
        Linkify.addLinks(text, Linkify.ALL);
    }

    private static CompoundButton.OnCheckedChangeListener createOnCheckedChangeListener() {
        return new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton compoundButton, boolean isChecked) {
                GoogleAnalyticsHelper.setGoogleAnalyticsOptOut(!isChecked);
            }
        };
    }
}
