/*
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License ("License") as
 * published by the Free Software Foundation  (version 3 of the License).
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the
 * License you received along with this software for more details.
 */

package de.avm.android.tr064;

public class Tr064Log
{
    public interface LogListener
    {
        void i(String tag, String message);
        void i(String tag, String message, Throwable e);
        void d(String tag, String message);
        void d(String tag, String message, Throwable e);
        void w(String tag, String message);
        void w(String tag, String message, Throwable e);
        void e(String tag, String message);
        void e(String tag, String message, Throwable e);
    }

    public static void setLogListener(LogListener listener)
    {
        mSingleton.setListener(listener);
    }

    public static void i(String tag, String message)
    {
        LogListener listener = mSingleton.getListener();
        if (listener == null)
            android.util.Log.i(tag, message);
        else
            listener.i(tag, message);
    }

    public static void i(String tag, String message, Throwable e)
    {
        LogListener listener = mSingleton.getListener();
        if (listener == null)
            android.util.Log.i(tag, message, e);
        else
            listener.i(tag, message, e);
    }

    public static void d(String tag, String message)
    {
        LogListener listener = mSingleton.getListener();
        if (listener == null)
            android.util.Log.d(tag, message);
        else
            listener.d(tag, message);
    }

    public static void d(String tag, String message, Throwable e)
    {
        LogListener listener = mSingleton.getListener();
        if (listener == null)
            android.util.Log.d(tag, message, e);
        else
            listener.d(tag, message, e);
    }

    public static void w(String tag, String message)
    {
        LogListener listener = mSingleton.getListener();
        if (listener == null)
            android.util.Log.w(tag, message);
        else
            listener.w(tag, message);
    }

    public static void w(String tag, String message, Throwable e)
    {
        LogListener listener = mSingleton.getListener();
        if (listener == null)
            android.util.Log.w(tag, message, e);
        else
            listener.w(tag, message, e);
    }

    public static void e(String tag, String message)
    {
        LogListener listener = mSingleton.getListener();
        if (listener == null)
            android.util.Log.e(tag, message);
        else
            listener.e(tag, message);
    }

    public static void e(String tag, String message, Throwable e)
    {
        LogListener listener = mSingleton.getListener();
        if (listener == null)
            android.util.Log.e(tag, message, e);
        else
            listener.e(tag, message, e);
    }

    private static Tr064Log mSingleton = new Tr064Log();
    private LogListener mListener = null;

    private Tr064Log()
    {
    }

    private synchronized void setListener(LogListener listener)
    {
        mListener = listener;
    }

    private synchronized LogListener getListener()
    {
        return mListener;
    }
}
