/* 
 * Copyright 2014 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

import android.os.Parcel;
import android.os.Parcelable;

/*
 *  Represents host name entry on Hosts interface as received from the Fritzbox 
 */
public class HostNameEntry implements Parcelable
{
	/*
	 * NewMACAddress	Out	String
	 * NewIPAddress		Out	String
	 * NewAddressSource	Out	String
	 * NewLeaseTimeRemaining	Out Long
	 * NewInterfaceType	Out String
	 * NewActive		Out Boolean
	 * NewHostName		Out	String
	*/

	private String mMACAddress;
	private String mIPAddress;
	private String mAddressSource;
	private long mLeaseTimeRemaining = 0L;
	private String mInterfaceType;
	private boolean mActive = false;
	private String mHostName;
	
	public String getMACAddress()
	{
		return mMACAddress;
	}
	
	public String getIPAddress()
	{
		return mIPAddress;
	}
	
	public void setIPAddress(String value)
	{
		mIPAddress = value;
	}
	
	public String getAddressSource()
	{
		return mAddressSource;
	}
	
	public void setAddressSource(String value)
	{
		mAddressSource = value;
	}
	
	public long getLeaseTimeRemaining()
	{
		return mLeaseTimeRemaining;
	}
	
	public void setLeaseTimeRemaining(long value)
	{
		mLeaseTimeRemaining = value;
	}
	
	public String getInterfaceType()
	{
		return mInterfaceType;
	}
	
	public void setInterfaceType(String value)
	{
		mInterfaceType = value;
	}

	public boolean isActive()
	{
		return mActive;
	}
	
	public void setActive(boolean value)
	{
		mActive = value;
	}
	
	public String getHostName()
	{
		return mHostName;
	}
	
	public void setHostName(String value)
	{
		mHostName = value;
	}

	public HostNameEntry(String macAddress)
	{
		mMACAddress = macAddress;
	}

	public HostNameEntry(Parcel in)
	{
		mMACAddress = in.readString();
		mIPAddress = in.readString();
		mAddressSource = in.readString();
		mLeaseTimeRemaining = in.readLong();
		mInterfaceType = in.readString();
		mActive = in.readInt() != 0;
		mHostName = in.readString();
	}

	public int describeContents()
	{
		return 0;
	}

	public static final Parcelable.Creator<HostNameEntry> CREATOR =
			new Parcelable.Creator<HostNameEntry>()
	{
		public HostNameEntry createFromParcel(Parcel in)
		{
			return new HostNameEntry(in);
		}

		public HostNameEntry[] newArray(int size)
		{
			return new HostNameEntry[size];
		}
	};

	public void writeToParcel(Parcel out, int flags)
	{
		out.writeString(mMACAddress);
		out.writeString(mIPAddress);
		out.writeString(mAddressSource);
		out.writeLong(mLeaseTimeRemaining);
		out.writeString(mInterfaceType);
		out.writeInt((mActive) ? 1 : 0);
		out.writeString(mHostName);
	}
}