/* 
 * Copyright 2013 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

public class LinkProperties
{
	/*
		NewWANAccessType Out  String 
		NewLayer1UpstreamMaxBitRate  Out ui4 
		NewLayer1DownstreamMaxBitRate Out  ui4 
		NewPhysicalLinkStatus Out  String 
	*/

	private String mWANAccessType;
	private long mLayer1UpstreamMaxBitRate;
	private long mLayer1DownstreamMaxBitRate;
	private String mPhysicalLinkStatus;

	public LinkProperties(String wanAccessType,
			long layer1UpstreamMaxBitRate,
			long layer1DownstreamMaxBitRate,
			String physicalLinkStatus)
	{
		mWANAccessType = wanAccessType;
		mLayer1UpstreamMaxBitRate = layer1UpstreamMaxBitRate;
		mLayer1DownstreamMaxBitRate = layer1DownstreamMaxBitRate;
		mPhysicalLinkStatus = physicalLinkStatus;
	}
	
	public String getWANAccessType()
	{
		return mWANAccessType;
	}
	
	public long getLayer1UpstreamMaxBitRate()
	{
		return mLayer1UpstreamMaxBitRate;
	}
	
	public long getLayer1DownstreamMaxBitRate()
	{
		return mLayer1DownstreamMaxBitRate;
	}
	
	public String getPhysicalLinkStatus()
	{
		return mPhysicalLinkStatus;
	}
}