/*
 * Copyright 2013 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License ("License") as
 * published by the Free Software Foundation  (version 3 of the License).
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

public class UnsignedNumber
{
	private static final int MAX_UI2 = 65535; 
	private static final long MAX_UI4 = 4294967295L; 
	
	public static void validateUi2(int value, String label)
			throws IllegalArgumentException
	{
		if (value < 0)
			throw new IllegalArgumentException("Argument " + label +
					" must not be less than 0.");
		if (value > MAX_UI2)
			throw new IllegalArgumentException("Argument " + label +
					" must not be more than " + MAX_UI2 + ".");
	}

	public static void validateUi4(long value, String label)
			throws IllegalArgumentException
	{
		if (value < 0L)
			throw new IllegalArgumentException("Argument " + label +
					" must not be less than 0.");
		if (value > MAX_UI4)
			throw new IllegalArgumentException("Argument " + label +
					" must not be more than " + MAX_UI4 + ".");
	}
}
