/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

import android.os.Parcel;
import android.os.Parcelable;

/*
 *  Represents information on User Interface as received from the Fritzbox 
 */
public class UpdateInfo implements Parcelable
{
	/*
	 * NewX_AVM-DE_AutoUpdateMode	Out	String
	 * NewX_AVM-DE_UpdateTime	    Out	DateTime
	 * NewX_AVM-DE_LastFwVersion	Out	String
	 * NewX_AVM-DE_LastInfoURL	    Out	String
	 * NewX_AVM-DE_CurrentFwVersion	Out	String
	 * NewX_AVM-DE_UpdateSuccessful	Out	String
	*/

	private String mAutoUpdateMode;
	private long mUpdateTime = 0;
	private String mLastFwVersion;
	private String mLastInfoURL;
	private String mCurrentFwVersion;
	private String mUpdateSuccessful;

    public String getAutoUpdateMode()
    {
        return mAutoUpdateMode;
    }

    public void setAutoUpdateMode(String autoUpdateMode)
    {
        mAutoUpdateMode = autoUpdateMode;
    }

    public long getUpdateTime()
    {
        return mUpdateTime;
    }

    public void setUpdateTime(long updateTime)
    {
        mUpdateTime = updateTime;
    }

    public String getLastFwVersion()
    {
        return mLastFwVersion;
    }

    public void setLastFwVersion(String lastFwVersion)
    {
        mLastFwVersion = lastFwVersion;
    }

    public String getLastInfoURL()
    {
        return mLastInfoURL;
    }

    public void setLastInfoURL(String lastInfoURL)
    {
        mLastInfoURL = lastInfoURL;
    }

    public String getCurrentFwVersion()
    {
        return mCurrentFwVersion;
    }

    public void setCurrentFwVersion(String currentFwVersion)
    {
        mCurrentFwVersion = currentFwVersion;
    }

    public String getUpdateSuccessful()
    {
        return mUpdateSuccessful;
    }

    public void setUpdateSuccessful(String updateSuccessful)
    {
        mUpdateSuccessful = updateSuccessful;
    }

    public UpdateInfo()
	{
	}

	public int describeContents()
	{
		return 0;
	}

	public static final Creator<UpdateInfo> CREATOR =
			new Creator<UpdateInfo>()
	{
		public UpdateInfo createFromParcel(Parcel in)
		{
			return new UpdateInfo(in);
		}

		public UpdateInfo[] newArray(int size)
		{
			return new UpdateInfo[size];
		}
	};

    public UpdateInfo(Parcel in)
    {
        mAutoUpdateMode = in.readString();
        mUpdateTime = in.readLong();
        mLastFwVersion = in.readString();
        mLastInfoURL = in.readString();
        mCurrentFwVersion = in.readString();
        mUpdateSuccessful = in.readString();
    }

	public void writeToParcel(Parcel out, int flags)
	{
		out.writeString(mAutoUpdateMode);
		out.writeLong(mUpdateTime);
		out.writeString(mLastFwVersion);
		out.writeString(mLastInfoURL);
		out.writeString(mCurrentFwVersion);
		out.writeString(mUpdateSuccessful);
	}
}