/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.model;

import android.os.Parcel;
import android.os.Parcelable;

/*
 *  Represents information on a VoIP client. As received from the Fritzbox 
 */
public class VoIPClientInfo implements Parcelable
{
	/*
		NewX_AVM-DE_ClientIndex  In  Int  index in list (0 <= index < count) 
		NewX_AVM-DE_ClientUsername  Out  String  user name 
		NewX_AVM-DE_ClientRegistrar Out  String  registrar 
		NewX_AVM-DE_PhoneName Out  String  user friendly name
		NewX_AVM-DE_OutGoingNumber Out  String  external phone number
		optional (extended, not supported by all box' versions)
		NewX_AVM-DE_ClientId Out  String  additional ID
	*/

	private int mIndex;
	private String mUsername = "";
	private String mRegistrar = "";
	private String mName = "";
	private String mOutgoingNumber = "";
	private String mId = "";

	public VoIPClientInfo(int index)
	{
		mIndex = index;
	}
	
	public VoIPClientInfo(Parcel in)
	{
		mIndex = in.readInt();
		mUsername = in.readString();
		mRegistrar = in.readString();
		mName = in.readString();
		mOutgoingNumber = in.readString();
		mId = in.readString();
	}
	
	public int getIndex()
	{
		return mIndex;
	}

	public void setUsername(String username)
	{
		mUsername = username;
	}

	public String getUsername()
	{
		return mUsername;
	}

	public void setRegistrar(String registrar)
	{
		mRegistrar = registrar;
	}

	public String getRegistrar()
	{
		return mRegistrar;
	}

	public void setName(String name)
	{
		mName = name;
	}

	public String getName()
	{
		return mName;
	}

	public void setOutgoingNumber(String outgoingNumber)
	{
		mOutgoingNumber = outgoingNumber;
	}

	public String getOutgoingNumber()
	{
		return mOutgoingNumber;
	}

	public void setId(String id)
	{
		mId = id;
	}

	public String getId()
	{
		return mId;
	}

	public int describeContents()
	{
		return 0;
	}

	public static final Parcelable.Creator<VoIPClientInfo> CREATOR =
			new Parcelable.Creator<VoIPClientInfo>()
	{
		public VoIPClientInfo createFromParcel(Parcel in)
		{
			return new VoIPClientInfo(in);
		}

		public VoIPClientInfo[] newArray(int size)
		{
			return new VoIPClientInfo[size];
		}
	};

	public void writeToParcel(Parcel out, int flags)
	{
		out.writeInt(mIndex);
		out.writeString(mUsername);
		out.writeString(mRegistrar);
		out.writeString(mName);
		out.writeString(mOutgoingNumber);
		out.writeString(mId);
	}
}