/* 
 * Copyright 2013 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.net;

import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class DefaultHttpClientFactory
{
	/**
	 * Creates instance of DefaultHttpClient
	 * 
	 * @param timeout timeout for requests (0 for default)
	 * @return
	 */
	public static DefaultHttpClient create(int timeout)
	{
		if (timeout > 0)
		{
			// default timeout is far too long for all those boxes not present yet
			HttpParams httpParams = new BasicHttpParams();
			HttpConnectionParams.setSoTimeout(httpParams, timeout);
			HttpConnectionParams.setConnectionTimeout(httpParams, timeout);
			return new DefaultHttpClient(httpParams);
		}
		return new DefaultHttpClient();
	}
}
