/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.net;

import java.io.IOException;
import java.io.InputStream;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.AbstractHttpClient;

import de.avm.android.tr064.Tr064Log;

public class WebUtil
{
    private static final String TAG = "WebUtil";

	public static InputStream getContentAsInputStream(String url, AbstractHttpClient client)
	{
		try
		{
			client.addRequestInterceptor(new GzipHttpRequestInterceptor());
			client.addResponseInterceptor(new GzipHttpResponseInterceptor());

			HttpGet httpGet = new HttpGet(url);
			HttpResponse response = client.execute(httpGet);
			HttpEntity entity = response.getEntity();
			if (entity == null) return null;
			return entity.getContent();

		}
		catch (ClientProtocolException e)
		{
            Tr064Log.w(TAG, e.getMessage(), e);
		}
		catch (IOException e)
		{
            Tr064Log.w(TAG, e.getMessage(), e);
		}
		return null;
	}
}