/* 
 * Copyright 2012 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.sax;

import de.avm.android.tr064.Tr064Capabilities;

/*
 * SAX-Handler for FRITZ!Box X_AVM-DE_OnTel1 description
 */
public class SAXDeviceConfigScpdHandler extends SAXScpdHandler
{
	public boolean isCapabilitiyOfInterface(Tr064Capabilities cap)
	{
		return cap.has(Tr064Capabilities.Capability.SID_FOR_URLS);
	}
	
	/**
	 * Instantiates a new sAX FRITZ!Box DeviceInfo1 description handler.
	 */
	public SAXDeviceConfigScpdHandler()
	{
		initActionsArray(new String[]
		{
			"X_AVM-DE_CreateUrlSID"
		});
	}

	@Override
	public Tr064Capabilities getCapabilities()
	{
		if (mActions[0].mIsAvailable)
			return new Tr064Capabilities(
					Tr064Capabilities.Capability.SID_FOR_URLS);

		return Tr064Capabilities.EMPTY;
	}
}
