/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.appsetup;

import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.soap.ISoapCredentials;

import java.io.IOException;

public class SetAppVPN extends AppSetupSoapHelper<Boolean>
{
	private String mAppId;
    private String mIPSecId;
    private String mIPSecPreSharedKey;
    private String mIPSecXauthUsername;
    private String mIPSecXauthPassword;

	/**
	 * Configuration of a VPN (IPsec) access for the app instance
	 *
	 * @param appId
	 * 		Identifier of the app instance the VPN configuration belongs to
     * @param ipSecId
     * 		IPSec identifier
     * @param ipSecPreSharedKey
     * 		IPSec pre-shared-key
     * @param ipSecXauthUsername
     * 		Username for xauth
     * @param ipSecXauthPassword
     * 		Password for xauth
	 */
	public SetAppVPN(ISoapCredentials soapCredentials, String appId, String ipSecId,
            String ipSecPreSharedKey, String ipSecXauthUsername, String ipSecXauthPassword)
	{
		super(soapCredentials);

        mAppId = appId;
        mIPSecId = ipSecId;
        mIPSecPreSharedKey = ipSecPreSharedKey;
        mIPSecXauthUsername = ipSecXauthUsername;
        mIPSecXauthPassword = ipSecXauthPassword;
	}

    @Override
	public Boolean getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		// no out parameter, check for error response
		exceptOnFault(getSoapBody());
        return Boolean.TRUE;
	}

	@Override
	public String getSoapMethodParameter()
	{
		return "<NewAppId>" + encodeEntities(mAppId) + "</NewAppId>" +
                "<NewIPSecIdentifier>" + encodeEntities(mIPSecId) + "</NewIPSecIdentifier>" +
                "<NewIPSecPreSharedKey>" + encodeEntities(mIPSecPreSharedKey) + "</NewIPSecPreSharedKey>" +
                "<NewIPSecXauthUsername>" + encodeEntities(mIPSecXauthUsername) + "</NewIPSecXauthUsername>" +
                "<NewIPSecXauthPassword>" + encodeEntities(mIPSecXauthPassword) + "</NewIPSecXauthPassword>";
	}

    @Override
    protected String filterSoapBeforeTrace(String body)
    {
        return replaceSecrets(body,
                new String[] { "NewIPSecPreSharedKey", "NewIPSecXauthUsername",
                        "NewIPSecXauthPassword" });
    }

	@Override
	public String getSoapMethod()
	{
		return "SetAppVPN";
	}
}
