/*
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License ("License") as
 * published by the Free Software Foundation  (version 3 of the License).
 * This software is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.myfritz;

import java.io.IOException;
import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.model.MyFritzService;
import de.avm.android.tr064.model.UnsignedNumber;
import de.avm.android.tr064.model.MyFritzService.IPv4ForwardingWarning;
import de.avm.android.tr064.soap.ISoapCredentials;

public class GetServiceByIndex extends MyFritzSoapHelper<MyFritzService>
{
	private long mIndex;

	/**
     * @param index index of service
	 * @throws IllegalArgumentException
	 * 		illegal value of index
	 */
	public GetServiceByIndex(ISoapCredentials soapCredentials, long index)
	{
		super(soapCredentials);
		UnsignedNumber.validateUi4(index, "index");
		mIndex = index;
	}

    public long getIndex()
    {
        return mIndex;
    }

    /**
     * @param index index of service
     * @throws IllegalArgumentException
     * 		illegal value of index
     */
    public GetServiceByIndex setIndex(long index)
    {
        UnsignedNumber.validateUi4(index, "index");
        mIndex = index;
        return this;
    }

	@Override
	public MyFritzService getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		try
		{
			String input = getSoapBody();

			MyFritzService fritzService = new MyFritzService();
			fritzService.setIndex(mIndex);
			fritzService.setEnabled(getBooleanByName("NewEnabled", input));
			fritzService.setName(getValueByName("NewName", input));
			fritzService.setScheme(getValueByName("NewScheme", input));
			fritzService.setPort(getIntByName("NewPort", input));
			fritzService.setURLPath(getValueByName("NewURLPath", input));
			fritzService.setType(getValueByName("NewType", input));
			fritzService.setIPv4ForwardingWarning(IPv4ForwardingWarning.parse(
					getValueByName("NewIPv4ForwardingWarning", input)));
			fritzService.setIPv4Addresses(getValueByName("NewIPv4Addresses", input));
			fritzService.setIPv6Addresses(getValueByName("NewIPv6Addresses", input));
			fritzService.setIPv6InterfaceIDs(getValueByName("NewIPv6InterfaceIDs", input));
			fritzService.setMACAddress(getValueByName("NewMACAddress", input));
			fritzService.setHostName(getValueByName("NewHostName", input));
			fritzService.setDynDnsLabel(getValueByName("NewDynDnsLabel", input));
			fritzService.setStatus(getLongByName("NewStatus", input));

			return fritzService;
		}
		catch (NumberFormatException | IndexOutOfBoundsException exp)
		{
			throw new DataMisformatException(getInvalidResponseErrorMessage(), exp);
		}
    }

	@Override
	public String getSoapMethodParameter()
	{
		return "<NewIndex>" + Long.toString(mIndex) + "</NewIndex>";
	}

	@Override
	public String getSoapMethod()
	{
		return "GetServiceByIndex";
	}
}
