/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.voip;

import java.io.IOException;
import android.text.TextUtils;

import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.model.StringSpec;
import de.avm.android.tr064.model.VoIPInfoEx;
import de.avm.android.tr064.soap.ISoapCredentials;

public class GetInfoEx extends VoIPConfSoapHelper<VoIPInfoEx>
{
	public GetInfoEx(ISoapCredentials soapCredentials)
	{
		super(soapCredentials);
	}

	@Override
	public VoIPInfoEx getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
        String input = getSoapBody();

        try
        {
            VoIPInfoEx infoEx = new VoIPInfoEx();
            infoEx.setVoIPPasswordSpec(new StringSpec(
                    getIntByName("NewVoIPPasswordMinChars", input),
                    getIntByName("NewVoIPPasswordMaxChars", input),
                    getValueByName("NewVoIPPasswordAllowedChars", input)));
            return infoEx;
        }
        catch (IllegalArgumentException exp)
        {
            throw new DataMisformatException(getInvalidResponseErrorMessage(), exp);
        }
	}

	@Override
	public String getSoapMethod()
	{
		return "GetInfoEx";
	}
}