/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.wanpppconnection;

import java.io.IOException;
import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.model.PortMapping;
import de.avm.android.tr064.model.UnsignedNumber;
import de.avm.android.tr064.soap.ISoapCredentials;

public class GetGenericPortMappingEntry extends WANPPPConnectionSoapHelper<PortMapping>
{
	private int mIndex;

	/**
	 * @throws IllegalArgumentException
	 * 		illegal value of index 
	 */
	public GetGenericPortMappingEntry(ISoapCredentials soapCredentials, int index)
	{
		super(soapCredentials);
		UnsignedNumber.validateUi2(index, "index");
		mIndex = index;
	}

    public int getIndex()
    {
        return mIndex;
    }

    /**
     * @param index
     * 		Index of entry
     * @throws IllegalArgumentException
     * 		illegal value of index
     */
    public GetGenericPortMappingEntry setIndex(int index)
    {
        UnsignedNumber.validateUi2(index, "index");
        mIndex = index;
        return this;
    }

	@Override
	public PortMapping getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		String input = getSoapBody();

		PortMapping portMapping = new PortMapping();
		portMapping.setRemoteHost(getValueByName("NewRemoteHost", input));
		portMapping.setExternalPort(getIntByName("NewExternalPort", input));
		portMapping.setProtocol(getValueByName("NewProtocol", input));
		portMapping.setInternalPort(getIntByName("NewInternalPort", input));
		portMapping.setInternalClient(getValueByName("NewInternalClient", input));
		portMapping.setEnabled(getBooleanByName("NewEnabled", input));
		portMapping.setPortMappingDescription(getValueByName("NewPortMappingDescription",
				input));
		portMapping.setLeaseDuration(getLongByName("NewLeaseDuration", input));

		return portMapping;
	}

	@Override
	public String getSoapMethodParameter()
	{
		return "<NewPortMappingIndex>" + Integer.toString(mIndex) + "</NewPortMappingIndex>";
	}

	@Override
	public String getSoapMethod()
	{
		return "GetGenericPortMappingEntry";
	}
}