/* 
 * Copyright 2015 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.wlanconfiguration;

import java.io.IOException;
import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.model.WLANHybridMode;
import de.avm.android.tr064.model.WLANHybridMode.BeaconType;
import de.avm.android.tr064.model.WLANHybridMode.TrafficMode;
import de.avm.android.tr064.soap.ISoapCredentials;

public class GetWLANHybridMode extends WLANSoapHelper<WLANHybridMode>
{
	/**
	 * Gets WLAN hybrid mode info
	 * 
	 * @param soapCredentials
	 * @param interfaceIndex
	 * 		Index of WLAN configuration interface
	 */
	public GetWLANHybridMode(ISoapCredentials soapCredentials, int interfaceIndex)
	{
		super(soapCredentials, interfaceIndex);
	}

	@Override
	public WLANHybridMode getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		String input = getSoapBody();
		
		WLANHybridMode result = new WLANHybridMode();
		result.setEnable(getBooleanByName("NewEnable", input));
		result.setBeaconType(BeaconType.getFromKey(getValueByName("NewBeaconType", input)));
		result.setKeyPassphrase(getValueByName("NewKeyPassphrase", input));
		result.setSsid(getValueByName("NewSSID", input));
		result.setBssid(getValueByName("NewBSSID", input));
		result.setTrafficMode(TrafficMode.getFromKey(getValueByName("NewTrafficMode", input)));
		switch (getIntByName("NewManualSpeed", input))
		{
			case 0:
				break;
			case 1:
				result.setManualSpeed(getLongByName("NewMaxSpeedDS", input),
						getLongByName("NewMaxSpeedUS", input));
				break;
			default:
				throw new DataMisformatException(getInvalidResponseErrorMessage());
		}

		return result;
	}

	@Override
	protected String filterSoapBeforeTrace(String body)
	{
        return replaceSecrets(body, new String[] { "NewKeyPassphrase" });
	}

	@Override
	public String getSoapMethod()
	{
		return "X_AVM-DE_GetWLANHybridMode";
	}
}
