/* 
 * Copyright 2014 by AVM GmbH <info@avm.de>
 *
 * This software contains free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License ("License") as 
 * published by the Free Software Foundation  (version 3 of the License). 
 * This software is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the copy of the 
 * License you received along with this software for more details.
 */

package de.avm.android.tr064.soap.wlanconfiguration;

import java.io.IOException;
import de.avm.android.tr064.exceptions.BaseException;
import de.avm.android.tr064.exceptions.DataMisformatException;
import de.avm.android.tr064.model.WPSInfo;
import de.avm.android.tr064.soap.ISoapCredentials;

public class SetWPSConfig extends WLANSoapHelper<WPSInfo>
{
	
	private String mMode;
	private String mClientPin;
	
	/**
	 * Sets WLAN WPS configuration
	 * 
	 * @param soapCredentials
	 * @param interfaceIndex
	 * 		Index of WLAN configuration interface
	 * @param mode
	 * 		The WPS mode
	 * @param clientPin
	 * 		The WPS client's PIN
	 * @throws IllegalArgumentException
	 * 		illegal value of interfaceIndex 
	 */
	
	public SetWPSConfig(ISoapCredentials soapCredentials, int interfaceIndex,
			String mode, String clientPin)
	{
		super(soapCredentials, interfaceIndex);
		
		mMode = mode;
		mClientPin = clientPin;
	}

	@Override
	public WPSInfo getQualifiedResult()
			throws DataMisformatException, BaseException, IOException
	{
		String input = getSoapBody();
		return  new WPSInfo(mMode,
				getValueByName("NewX_AVM-DE_WPSStatus", input),
				getValueByName("NewX_AVM-DE_WPSAPPIN", input));
	}

	@Override
	public String getSoapMethodParameter()
	{
		return "<NewX_AVM-DE_WPSMode>" + mMode + "</NewX_AVM-DE_WPSMode>" +
				"<NewX_AVM-DE_WPSClientPIN>" + mClientPin + "</NewX_AVM-DE_WPSClientPIN>";
	}

    @Override
    protected String filterSoapBeforeTrace(String body)
    {
        return replaceSecrets(body, new String[] { "NewX_AVM-DE_WPSClientPIN" });
    }

	@Override
	public String getSoapMethod()
	{
		return "X_AVM-DE_SetWPSConfig";
	}
}
